<?php

require_once("../../loader.php");

$db = new Conexion;
$user = new User;
$core = new Core;
$userData = $user->cdp_getUserData();

$customer_id = intval($_REQUEST['customer_id']);
$pay_mode = intval($_REQUEST['pay_mode']);
$range = cdp_sanitize($_REQUEST['range']);


$sWhere = "";


if ($customer_id > 0) {

	$sWhere .= " and b.sender_id = '" . $customer_id . "'";
}


if ($pay_mode > 0) {

	$sWhere .= " and a.payment_type = '" . $pay_mode . "'";
}


if (!empty($range)) {

	$fecha =  explode(" - ", $range);
	$fecha = str_replace('/', '-', $fecha);

	$fecha_inicio = date('Y-m-d', strtotime($fecha[0]));
	$fecha_fin = date('Y-m-d', strtotime($fecha[1]));


	$sWhere .= " and  a.charge_date between '" . $fecha_inicio . "'  and '" . $fecha_fin . "'";
}

// // pagination variables
$page = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
$per_page = 10; //how much records you want to show
$adjacents  = 4; //gap between pages after number of adjacents
$offset = ($page - 1) * $per_page;


$sql = "SELECT c.lname, c.fname, a.id_charge, b.order_prefix, b.order_no, a.payment_type, a.charge_date, a.total, b.currency, b.receiver_id 
                FROM cdb_charges_order as a 
				INNER JOIN cdb_add_order as b ON a.order_id = b.order_id
				INNER JOIN cdb_users as c ON c.id = b.sender_id
				$sWhere
				order by a.id_charge
			 ";


$query_count = $db->cdp_query($sql);
$db->cdp_execute();
$numrows = $db->cdp_rowCount();

$db->cdp_query($sql . " limit $offset, $per_page");
$data = $db->cdp_registros();

$total_pages = ceil($numrows / $per_page);

$db->cdp_query($sql);
$data = $db->cdp_registros();

$db->cdp_query($sql);
$curr = $db->cdp_registro();


if ($numrows > 0) { ?>
	<div class="table-responsive">


		<table id="zero_config" class="table-sm table table-condensed table-hover table-striped custom-table-checkbox">
			<thead>
				<tr style="background-color: #3e5569; color: white">
					<th class="text-center"><b>Payment number</b></th>
					<th class="text-center"><b><?php echo $lang['ddate'] ?></b></th>
					<th class="text-center"><b>Customer</b></th>
					<th class="text-center"><b>Receiver</b></th>
					<th class="text-center"><b>Pay mode</b></th>
					<th class="text-center"><b><?php echo $lang['ltracking'] ?></b></th>
					<th class="text-center"><b>Amount</b></th>

				</tr>
			</thead>
			<tbody id="projects-tbl">


				<?php if (!$data) { ?>
					<tr>
						<td colspan="6">
							<?php echo "
				<i align='center' class='display-3 text-warning d-block'><img src='assets/images/alert/ohh_shipment.png' width='150' /></i>								
				", false; ?>
						</td>
					</tr>
				<?php } else { ?>

					<?php

					$count = 0;
					$sumador_total = 0;

					foreach ($data as $row) {

						// var_dump($row->id);
						$db->cdp_query('SELECT  * FROM cdb_met_payment WHERE id=:id');

						$db->bind(':id', $row->payment_type);

						$db->cdp_execute();

						$met_payment = $db->cdp_registro();


						$sumador_total += $row->total;
						
						$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->receiver_id . "'");
						$receiver_data = $db->cdp_registro();

					?>


						<tr class="card-hover">

							<td class="text-center">
								<?php echo $row->id_charge; ?>
							</td>

							<td class="text-center">
								<?php echo $row->charge_date; ?>
							</td>


							<td class="text-center">
								<?php echo $row->fname . ' ' . $row->lname; ?>
							</td>
							<td class="text-center">
								<?php echo $receiver_data->fname . ' ' . $receiver_data->lname; ?>
							</td>
							<td class="text-center">
								<?php echo $met_payment->name_pay; ?>
							</td>

							<td class="text-center">
								<?php echo $row->order_prefix . $row->order_no; ?>
							</td>

							<td class="text-center">
								<?php echo $row->currency; ?><?php echo $row->total; ?>
							</td>
						</tr>
					<?php $count++;
					} ?>

				<?php } ?>
			</tbody>
			<tfoot>

				<tr class="card-hover">
					<td class="text-center"><b>TOTAL</b></td>
					<td colspan="3"></td>
					<td class="text-center">
						<b><?php echo number_format($sumador_total); ?> </b>
					</td>
					<td class="text-center">
						<b><?php echo $dol($sumador_total); ?> </b>
					</td>

				</tr>
			</tfoot>

		</table>
		
		<div class="pull-right">
			<?php echo cdp_paginate($page, $total_pages, $adjacents);	?>
		</div>
		
	</div>
<?php } ?>